/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.patron_pet.player;

import com.alexander.mutantmore.patron_pet.player.PlayerPatronPetDataProvider;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SyncPatronPetDataToServerPacket {
    private final boolean spawnParticles;
    private final boolean playAudio;
    private final boolean active;

    public SyncPatronPetDataToServerPacket(boolean spawnParticles, boolean playAudio, boolean active) {
        this.spawnParticles = spawnParticles;
        this.playAudio = playAudio;
        this.active = active;
    }

    public SyncPatronPetDataToServerPacket(FriendlyByteBuf buf) {
        this.spawnParticles = buf.readBoolean();
        this.playAudio = buf.readBoolean();
        this.active = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.spawnParticles);
        buf.writeBoolean(this.playAudio);
        buf.writeBoolean(this.active);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            player.getCapability(PlayerPatronPetDataProvider.PLAYER_PATRON_PET_DATA).ifPresent(data -> {
                data.setActive(this.active);
                data.setPlayAudio(this.playAudio);
                data.setSpawnParticles(this.spawnParticles);
            });
        });
        return true;
    }
}

